/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.mozilla.javascript.RhinoSecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityUtilities {
    public static String getSystemProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }

    public static ProtectionDomain getProtectionDomain(final Class<?> clazz2) {
        return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return clazz2.getProtectionDomain();
            }
        });
    }

    public static ProtectionDomain getScriptProtectionDomain() {
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof RhinoSecurityManager) {
            return AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

                @Override
                public ProtectionDomain run() {
                    Class c = ((RhinoSecurityManager)securityManager).getCurrentScriptClass();
                    return c == null ? null : c.getProtectionDomain();
                }
            });
        }
        return null;
    }
}

